<?php


class ProduitModele extends Modele{

    private $parametres = []; // Remarque : cette proriété est de type => tableau


    function __construct($parametres){

        $this->parametres = $parametres;

    }


    public function getListeProduits()
    {

        $sql = 'SELECT * FROM produit';

        $idRequete = $this->executeRequete($sql);

        // Retour la totalité des clients
        // return $idRequete->fetchall(PDO::FETCH_ASSOC);

        if ($idRequete->rowCount() > 0) {

            while ($produit = $idRequete->fetch(PDO::FETCH_ASSOC)) {


                $listeProduits[] = new ProduitTable($produit);

            }

            return $listeProduits;

        } else {

            return null;
        }
    }
    public function getUnProduit(){

            $sql = 'SELECT * FROM produit WHERE reference = ?';

            $idRequete = $this->executeRequete($sql, [$this->parametres["reference"]]);

            $unProduit = new ProduitTable($idRequete->fetch(PDO::FETCH_ASSOC));

            return $unProduit;
    }
    public function addProduit(ProduitTable $produit)
    {
        $sql = 'INSERT INTO produit(reference,descriptif,designation,poids_pièce,prix_unitaire_HT)VALUES(?,?,?,?,?)';

        $idRequete = $this->executeRequete($sql, [

            $produit->getReference(),
            $produit->getDescriptif(),
            $produit->getDesignation(),
            $produit->getPoidsPiece(),
            $produit->getPrixUnitaireHT(),
        ]);
        if($idRequete){
            ProduitTable::setMessageSucces("ajout avec succès");
        }
    }

    public function editClient(ClientTable $client)
    {
        $sql = 'UPDATE client SET nom = ?, adresse = ?, cp = ?, ville = ?, telephone = ? WHERE codec = ?';

        $idRequete = $this->executeRequete($sql, [

            $client->getNom(),
            $client->getAdresse(),
            $client->getCp(),
            $client->getVille(),
            $client->getTelephone(),
            $client->getCodec(),
        ]);
        if($idRequete){
            ClientTable::setMessageSucces("modifié avec succes");
        }
    }

    public function supressionPossible()
    {
        $sql = 'SELECT COUNT(*) AS nombre FROM commande WHERE reference = ?';
        $idRequete = $this->executeRequete($sql, [$this->parametres['reference']]);
        $row = $idRequete->fetch(PDO::FETCH_ASSOC);
        if ($row["nombre"] > 0) {
            return false;
        }else{
            return true;
        }
    }
    public function deleteClient(){
        $sql = 'DELETE FROM client WHERE reference = ?';
        $idRequete = $this->executeRequete($sql, [$this->parametres['reference']]);

        if ($idRequete) {

            ProduitTable::setMessageSucces("suppression avec succes");
        }
    }

    public function stat01(ProduitTable  $unProduit){
        $sql = 'SELECT  ROUND(
                CASE 
                    WHEN descriptif = "G" THEN (prix_unitaire_HT / quantite) * 1000
                    WHEN descriptif = "P" AND poids_piece > 0 THEN (prix_unitaire_HT / (quantite * poids_piece)) * 1000
                    ELSE 0
                END ,2)
                    AS stat01 
            FROM produit
            WHERE reference = ?';

        $idRequete = $this->executeRequete($sql, [$this->parametres['reference']]);
        $row = $idRequete->fetch(PDO::FETCH_ASSOC);

        if ($row && $row["stat01"] != null) {
            $unProduit->setPrixAuKilo($row['stat01']);
        } else {
            $unProduit->setPrixAuKilo(0);
        }
    }


    public function pourcentageCaArticle(ProduitTable  $unProduit){
        $sql = 'SELECT 
    ROUND(
        SUM(CASE WHEN reference = ? THEN prix_unitaire_HT * quantite ELSE 0 END) 
        / 
        NULLIF(SUM(prix_unitaire_HT * quantite), 0) * 100, 2
    ) AS pourcentage_ca_article
FROM produit';

        $idRequete = $this->executeRequete($sql, [$this->parametres['reference']]);
        $row = $idRequete->fetch(PDO::FETCH_ASSOC);

        if ($row && $row["pourcentage_ca_article"] != null) {
            $unProduit->setPourcentageCaArticle($row['pourcentage_ca_article']);
        } else {
            $unProduit->setPourcentageCaArticle(0);
        }
    }


    public function topArticle(ProduitTable  $unProduit){
        $sql = 'SELECT classement
FROM (
    SELECT reference, 
           SUM(quantite) AS total_commandes,
           RANK() OVER (ORDER BY SUM(quantite) DESC) AS classement
    FROM produit
    GROUP BY reference
) AS classement_produits
WHERE reference = ?';

        $idRequete = $this->executeRequete($sql, [$this->parametres['reference']]);
        $row = $idRequete->fetch(PDO::FETCH_ASSOC);

        if ($row && $row["classement"] != null) {
            $unProduit->setClassement($row['classement']);
        } else {
            $unProduit->setClassement(0);
        }
    }

}
