<?php

class ProduitTable
{
    private $reference = "";
    private $descriptif = "";
    private $designation = "";
    private $poids_piece = "0";
    private $prix_unitaire_HT = "0";
    private $autorisationBD = "";
    private $quantite = 0;
    private $stock = "" ;
    private $prix_au_kilo = "";

    private $pourcentage_ca_article = "";

    private $classement = "";


    protected static $messageSucces = "";
    protected static $messageErreur = "";

    public function __construct($data = null)
    {
        if ($data != null) {
            $this->hydrater($data);
        }
    }

    public function hydrater(array $data)
    {
        foreach ($data as $key => $value) {
            $setter = 'set' . ucfirst($key);
            if (method_exists($this, $setter)) {
                $this->$setter($value);
            }
        }
    }

    public function getReference(): string
    {
        return $this->reference;
    }

    public function getDescriptif(): string
    {
        return $this->descriptif;
    }

    public function getDesignation(): string
    {
        return $this->designation;
    }

    public function getPoidsPiece(): string
    {
        return $this->poids_piece;
    }

    public function getPrixUnitaireHT(): string
    {
        return $this->prix_unitaire_HT;
    }

    public function setReference(string $reference): void
    {
        $this->reference = $reference;
    }

    public function setDescriptif(string $descriptif): void
    {
        $this->descriptif = $descriptif;
    }

    public function setDesignation(string $designation): void
    {
        $this->designation = $designation;
    }

    public function setPoids_piece(string $poids_piece): void
    {
        $this->poids_piece = $poids_piece;
    }

    public function setPrix_unitaire_HT(string $prix_unitaire_HT): void
    {
        $this->prix_unitaire_HT = $prix_unitaire_HT;
    }

    public function setAutorisationBD(string $autorisationBD): void
    {
        $this->autorisationBD = $autorisationBD;
    }

    public function getAutorisationBD(): string
    {
        return $this->autorisationBD;
    }

    public static function getMessageErreur(): string
    {
        return self::$messageErreur;
    }

    public static function getMessageSucces(): string
    {
        return self::$messageSucces;
    }

    public static function setMessageErreur(string $messageErreur): void
    {
        self::$messageErreur .= $messageErreur;
    }

    public static function setMessageSucces(string $messageSucces): void
    {
        self::$messageSucces = $messageSucces;
    }

    public function getQuantite(): int
    {
        return $this->quantite;
    }

    public function setQuantite(int $quantite): void
    {
        $this->quantite = $quantite;
    }

    public function getStock(): string
    {
        return $this->stock;
    }

    public function setStock(string $stock): void
    {
        $this->stock = $stock;
    }

    public function getPrixAuKilo(): string
    {
        return $this->prix_au_kilo;
    }

    public function setPrixAuKilo($valeur): void
    {
        $this->prix_au_kilo = $valeur;
    }

    public function getPourcentageCaArticle(): string
    {
        return $this->pourcentage_ca_article;
    }

    public function setPourcentageCaArticle(string $pourcentage_ca_article): void
    {
        $this->pourcentage_ca_article = $pourcentage_ca_article;
    }

    public function getClassement(): string
    {
        return $this->classement;
    }

    public function setClassement(string $classement): void
    {
        $this->classement = $classement;
    }






}
