<?php


class HistoriqueModele extends Modele{

    private $parametres = []; // Remarque : cette proriété est de type => tableau


    function __construct($parametres){

        $this->parametres = $parametres;

    }


    public function getListeHistoriques()
{
    $sql = 'SELECT DISTINCT Nom, designation, date_commande AS dateCommande, CONCAT(
        TIMESTAMPDIFF(DAY, date_commande, date_livraison), \' jours \',
        LPAD(TIMESTAMPDIFF(HOUR, date_commande, date_livraison) % 24, 2, \'0\'), \'h\',
        LPAD(TIMESTAMPDIFF(MINUTE, date_commande, date_livraison) % 60, 2, \'0\'), \'m\'
    ) AS NombreJourLivraison,
    quantite, 
    (total_HT + total_TVA) AS prixTTC
    FROM client 
    INNER JOIN commande ON client.codec = commande.codec 
    INNER JOIN ligne_commande ON commande.numero = ligne_commande.numero
    INNER JOIN produit ON ligne_commande.reference = produit.reference
    ORDER BY dateCommande DESC';


        // Aucune donnée à binder, donc pas de tableau en 2e paramètre
        $idRequete = $this->executeRequete($sql);

        $listeHistoriques = []; // ← Toujours initialiser pour éviter un warning

        if ($idRequete && $idRequete->rowCount() > 0) {
            while ($ligne = $idRequete->fetch(PDO::FETCH_ASSOC)) {
                $listeHistoriques[] = new HistoriqueTable($ligne);
            }
        }

        return $listeHistoriques;
    }

    public function getUnHistorique(){

            $sql = 'SELECT * FROM commande WHERE numero = ?';

            $idRequete = $this->executeRequete($sql, [$this->parametres["numero"]]);

            $unHistorique = new HistoriqueTable($idRequete->fetch(PDO::FETCH_ASSOC));

            return $unHistorique;
    }

}
