<?php

class CommandeVue
{
    private $parametres = []; // Remarque cette propriété est de type => tableau

    private $tpl; //objet Smarty

    //Constructeur

    public function __construct($parametres)
    {

        $this->parametres = $parametres;

        $this->tpl = new Smarty();

    }

    public function chargementValeurs()
    {
        $this->tpl->assign('login', $_SESSION['prenomNom']);

        $this->tpl->assign('titreVue', 'SERAPHIN PARYS');

    }

    public function genererAffichageListe($valeurs)
    {

        $this->chargementValeurs();

        $this->tpl->assign('messageSuccess', CommandeTable::getMessageSucces());
        $this->tpl->assign('titrePage','Liste des commandes');

        $this->tpl->assign('listeDesCommandes',$valeurs);

        $this->tpl->display('mod_commande/vue/commandeListeVue.tpl');


    }
    public function genererAffichageFiche($valeurs){

        $this->chargementValeurs();

        switch ($this->parametres["action"]){
            case "form_consulter":
                $this->tpl->assign('messageErreur', CommandeTable::getMessageErreur());
                $this->tpl->assign('titrePage', 'fiche commande : consultation');
                $this->tpl->assign('readonly', 'disabled');
                $this->tpl->assign('action', 'consulter');

                break;

            case "form_ajouter":
                case "ajouter":

                    $this->tpl->assign('messageErreur', CommandeTable::getMessageErreur());
                $this->tpl->assign('titrePage', 'fiche commande : Création');
                $this->tpl->assign('readonly', '');
                $this->tpl->assign('action', 'ajouter');

                break;

            case "form_modifier":
            case "modifier":

                $this->tpl->assign('messageErreur', CommandeTable::getMessageErreur());
                $this->tpl->assign('titrePage', 'fiche commande : modification');
                $this->tpl->assign('readonly', '');
                $this->tpl->assign('action', 'modifier');

                break;

            case "form_supprimer":
            case "supprimer":

                $this->tpl->assign('messageErreur', CommandeTable::getMessageErreur());
                $this->tpl->assign('titrePage', 'fiche commande : supprimer');
                $this->tpl->assign('readonly', 'disabled');
                $this->tpl->assign('action', 'supprimer');

                break;


        }
        $this->tpl->assign('unCommande', $valeurs);

        $this->tpl->display('mod_commande/vue/commandeFicheVue.tpl');
    }

}