<?php


class CommandeModele extends Modele{

    private $parametres = []; // Remarque : cette proriété est de type => tableau


    function __construct($parametres){

        $this->parametres = $parametres;

    }


    public function getListeCommandes()
    {

        $sql = 'SELECT * FROM produit';

        $idRequete = $this->executeRequete($sql);

        // Retour la totalité des clients
        // return $idRequete->fetchall(PDO::FETCH_ASSOC);

        if ($idRequete->rowCount() > 0) {

            while ($commande = $idRequete->fetch(PDO::FETCH_ASSOC)) {


                $listeCommandes[] = new CommandeTable($commande);

            }

            return $listeCommandes;

        } else {

            return null;
        }
    }
    public function getUnCommande(){

            $sql = 'SELECT 
                    reference, 
                    designation, 
                    stock, 
                    prix_unitaire_HT 
                    FROM produit;';

            $idRequete = $this->executeRequete($sql, [$this->parametres["numero"]]);

            $unCommande = new CommandeTable($idRequete->fetch(PDO::FETCH_ASSOC));

            return $unCommande;
    }
    public function addCommande(CommandeTable $commande)
    {
        $sql = 'INSERT INTO commande(nom,telephone,cp,ville,designation,quantite)VALUES(?,?,?,?,?,?)';

        $idRequete = $this->executeRequete($sql, [

            $commande->getNom(),
            $commande->getTelephone(),
            $commande->getCp(),
            $commande->getVille(),
            $commande->getDesignation(),
            $commande->getQuantite(),
        ]);
        if($idRequete){
            CommandeTable::setMessageSucces("ajout avec succès");
        }
    }

    public function editClient(ClientTable $client)
    {
        $sql = 'UPDATE client SET nom = ?, adresse = ?, cp = ?, ville = ?, telephone = ? WHERE codec = ?';

        $idRequete = $this->executeRequete($sql, [

            $client->getNom(),
            $client->getAdresse(),
            $client->getCp(),
            $client->getVille(),
            $client->getTelephone(),
            $client->getCodec(),
        ]);
        if($idRequete){
            ClientTable::setMessageSucces("modifié avec succes");
        }
    }

    public function supressionPossible()
    {
        $sql = 'SELECT COUNT(*) AS nombre FROM commande WHERE codec = ?';
        $idRequete = $this->executeRequete($sql, [$this->parametres['codec']]);
        $row = $idRequete->fetch(PDO::FETCH_ASSOC);
        if ($row["nombre"] > 0) {
            return false;
        }else{
            return true;
        }
    }
    public function deleteClient(){
        $sql = 'DELETE FROM client WHERE codec = ?';
        $idRequete = $this->executeRequete($sql, [$this->parametres['codec']]);

        if ($idRequete) {

            ClientTable::setMessageSucces("suppression avec succes");
        }
    }




}
