<?php

class CommandeTable
{

    private $codec = "";
    private $nom = "";
    private $adresse = "";
    private $cp = "";
    private $ville = "";
    private $telephone = "";

    private $stock = "";

    private $designation = "";

    private $quantite = "";

    private $numero = "";

    private $prix_unitaire_HT = "0";

    private $reference = "";

    private $coutTotal = "0" ;
    private $autorisationBD = "true";

    private static $messageErreur = "";

    private static $messageSucces = "";


    public function __construct($data = null)
    {

        if ($data != null) {

            $this->hydrater($data);
        }


    }

    public function hydrater(array $data)
    {
        foreach ($data as $key => $value) {
            //Concaténation du nom de la clé avec le préfixe set (construction pour l'appel du setter)
            $setter = 'set' . ucfirst($key);
            // appeler une fonction qui me permet de vérifier si la méthode de type setter existe.
            if (method_exists($this, $setter)) {
                // invoquer la méthode correspondante
                $this->$setter($value);
            }
        }
    }

    public function getCodec()
    {
        return $this->codec;
    }

    public function setCodec($codec)
    {
        $this->codec = $codec;
    }

    public function getNom(): string
    {
        return $this->nom;
    }

    public function setNom(string $nom): void
    {
        if (empty($nom) || ctype_space($nom)){

            $this->setAutorisationBD(false);
        self::setMessageErreur("le nom du client est obligatoire.");


    }
        $this->nom = $nom;
    }

    public function getAdresse(): string
    {
        return $this->adresse;
    }

    public function setAdresse(string $adresse): void
    {
        $this->adresse = $adresse;
    }

    public function getCp(): string
    {
        return $this->cp;
    }

    public function setCp(string $cp): void
    {
        if (empty($cp) || ctype_space($cp)){

        $this->setAutorisationBD(false);
        self::setMessageErreur("le code postal du client est obligatoire.");
    }
        $this->cp = $cp;
    }

    public function getVille(): string
    {
        return $this->ville;
    }

    public function setVille(string $ville): void
    {
        $this->ville = $ville;
    }

    public function getTelephone(): string
    {
        return $this->telephone;
    }

    public function setTelephone(string $telephone): void
    {
        $this->telephone = $telephone;
    }

    public function getAutorisationBD(): string
    {
        return $this->autorisationBD;
    }

    public static function getMessageErreur(): string
    {
        return self::$messageErreur;
    }

    public static function getMessageSucces(): string
    {
        return self::$messageSucces;
    }

    public function setAutorisationBD(string $autorisationBD): void
    {
        $this->autorisationBD = $autorisationBD;
    }

    public static function setMessageErreur(string $messageErreur): void
    {
        self::$messageErreur = self::$messageErreur . $messageErreur;    }

    public static function setMessageSucces(string $messageSucces): void
    {
        self::$messageSucces = $messageSucces;
    }

    public function getDesignation(): string
    {
        return $this->designation;
    }

    public function getQuantite(): string
    {
        return $this->quantite;
    }

    public function setDesignation(string $designation): void
    {
        $this->designation = $designation;
    }

    public function setQuantite(string $quantite): void
    {
        $this->quantite = $quantite;
    }

    public function getNumero(): string
    {
        return $this->numero;
    }

    public function setNumero(string $numero): void
    {
        $this->numero = $numero;
    }

    public function getReference(): string
    {
        return $this->reference;
    }

    public function setReference(string $reference): void
    {
        $this->reference = $reference;
    }


    public function getStock(): string
    {
        return $this->stock;
    }

    public function setStock(string $stock): void
    {
        $this->stock = $stock;
    }

    public function getPrix_unitaire_HT(): string
    {
        return $this->prix_unitaire_HT;
    }

    public function setPrix_unitaire_HT(string $prix_unitaire_HT): void
    {
        $this->prix_unitaire_HT = $prix_unitaire_HT;
    }



    public function getCoutTotal(): string {
        return number_format((float)$this->prix_unitaire_HT * 1.36, 2, '.', '');
    }


    public function setCoutTotal(string $coutTotal): void
    {
        $this->coutTotal = $coutTotal;
    }




}