<?php

class CommandeControleur{

    /* Espace déclaration des propriétés */
    private $parametres = []; // Remarque : cette proriété est de type => tableau

    private $oModele; // Remarque : cette proriété est de type => objet
    private $oVue; // Remarque : cette proriété est de type => objet

    /* Constructeur */
    /**
     * @param $parametres // contient les valeurs du tableau $_REQUEST ($_GET et $_POST))
     */
    public function __construct($parametres){
        // Initialisation de la propriété parametres
        $this->parametres = $parametres;

        $this->oModele = new CommandeModele($this->parametres);

        $this->oVue = new CommandeVue($this->parametres);

    }



    public function lister(){

        $lesCommandes = $this->oModele->getListeCommandes();


        $this->oVue->genererAffichageListe($lesCommandes);

    }

    public function form_consulter(){

        $unCommande = $this->oModele->getUnCommande();


        $this->oVue->genererAffichagefiche($unCommande);

    }

    public function form_ajouter(){

        $prepareCommande = new CommandeTable();

        $this->oVue->genererAffichageFiche($prepareCommande);

    }
    public function ajouter(){

    //je controle les données en prevenance du formualaire (sasie utilisateur)
    // si problème alors
    // retourne au formulaire d'ajout avec les données saisies précédément par l'utilisateur
        //message d'erreur
        //sinon ecriture en BDD (nouvelle enregistrement)
        //retourner la vue sur la liste avec un message de succès

        //contrôlle des données
        $controlDonnes = new CommandeTable($this->parametres);

        if($controlDonnes->getAutorisationBD() == false){

            $this->oVue->genererAffichageFiche($controlDonnes);

        }else{

            $this->oModele->addCommande($controlDonnes);
            $this->lister();
        }
    }

    public function form_supprimer(){

        $unCommande = $this->oModele->getUnCommande();

        $this->oVue->genererAffichagefiche($unCommande);

    }
    public function form_modifier(){

        $unCommande = $this->oModele->getUnCommande();

        $this->oVue->genererAffichageFiche($unCommande);

    }

    public function modifier(){

        //je controle les données en prevenance du formualaire (sasie utilisateur)
        // si problème alors
        // retourne au formulaire de modification avec les données saisies précédément par l'utilisateur
        //message d'erreur
        //sinon ecriture en BDD (modification enregistrement)
        //retourner la vue sur la liste avec un message de succès

        //contrôlle des données
        $controlDonnes = new CommandeTable($this->parametres);

        if($controlDonnes->getAutorisationBD() == false){

            $this->oVue->genererAffichageFiche($controlDonnes);

        }else{

            $this->oModele->editCommande($controlDonnes);
            $this->lister();
        }
}
        public function supprimer(){
            //je controle l'identifiant du client , est ce qu'il possède une commande ? '
            // si oui alors
            // retourne au formulaire de suppression
            //message d'erreur : client possède au moins une commande
            //sinon ecriture en BDD (nouvelle supression)
            //retourner la vue sur la liste avec un message de succès
            $controleSuppression = $this->oModele->supressionPossible();

            if($controleSuppression == false){
                CommandeTable::setMessageErreur("Impossible de supprimer le client. Celui ci possède au moins une commande.");
                $this->oVue->genererAffichageFiche($this->oModele->getUnCommande());
            }else{
                $this->oModele->deleteCommande();

                $this->lister();
            }
        }

}