<?php


class ClientModele extends Modele{

    private $parametres = []; // Remarque : cette proriété est de type => tableau


    function __construct($parametres){

        $this->parametres = $parametres;

    }


    public function getListeClients()
    {

        $sql = 'SELECT * FROM client';

        $idRequete = $this->executeRequete($sql);

        // Retour la totalité des clients
        // return $idRequete->fetchall(PDO::FETCH_ASSOC);

        if ($idRequete->rowCount() > 0) {

            while ($client = $idRequete->fetch(PDO::FETCH_ASSOC)) {


                $listeClients[] = new ClientTable($client);

            }

            return $listeClients;

        } else {

            return null;
        }
    }
    public function getUnClient(){

            $sql = 'SELECT * FROM client WHERE codec = ?';

            $idRequete = $this->executeRequete($sql, [$this->parametres["codec"]]);

            $unClient = new ClientTable($idRequete->fetch(PDO::FETCH_ASSOC));

            return $unClient;
    }
    public function addClient(ClientTable $client)
    {
        $sql = 'INSERT INTO client(nom,adresse,cp,ville,telephone)VALUES(?,?,?,?,?)';

        $idRequete = $this->executeRequete($sql, [

            $client->getNom(),
            $client->getAdresse(),
            $client->getCp(),
            $client->getVille(),
            $client->getTelephone(),
        ]);
        if($idRequete){
            ClientTable::setMessageSucces("ajout avec succès");
        }
    }

    public function editClient(ClientTable $client)
    {
        $sql = 'UPDATE client SET nom = ?, adresse = ?, cp = ?, ville = ?, telephone = ? WHERE codec = ?';

        $idRequete = $this->executeRequete($sql, [

            $client->getNom(),
            $client->getAdresse(),
            $client->getCp(),
            $client->getVille(),
            $client->getTelephone(),
            $client->getCodec(),
        ]);
        if($idRequete){
            ClientTable::setMessageSucces("modifié avec succes");
        }
    }

    public function supressionPossible()
    {
        $sql = 'SELECT COUNT(*) AS nombre FROM commande WHERE codec = ?';
        $idRequete = $this->executeRequete($sql, [$this->parametres['codec']]);
        $row = $idRequete->fetch(PDO::FETCH_ASSOC);
        if ($row["nombre"] > 0) {
            return false;
        }else{
            return true;
        }
    }
    public function deleteClient(){
        $sql = 'DELETE FROM client WHERE codec = ?';
        $idRequete = $this->executeRequete($sql, [$this->parametres['codec']]);

        if ($idRequete) {

            ClientTable::setMessageSucces("suppression avec succes");
        }
    }

    public function stat01(ClientTable  $clientEnCours){

        $sql = 'SELECT SUM(total_ht) AS stat01 FROM commande WHERE codec = ?';

        $idRequete = $this->executeRequete($sql, [$this->parametres['codec']]);

        $row = $idRequete->fetch(PDO::FETCH_ASSOC);

        if ($row["stat01"] != null) {

            $clientEnCours->setStat01($row['stat01']);

        }else{

            $clientEnCours->setStat01(0);

        }
    }

    public function pourcentage_client(ClientTable $clientEnCours)
    {
        $sql = 'SELECT ROUND(SUM(total_ht + total_tva) * 100.0 /
                (SELECT SUM(total_ht + total_tva) FROM commande) ,2) AS pourcentage_client
                FROM commande
                WHERE codec = ?';
        $idRequete = $this->executeRequete($sql, [$this->parametres['codec']]);

        $row = $idRequete->fetch(PDO::FETCH_ASSOC);

        if ($row["pourcentage_client"] != null) {

            $clientEnCours->setPourcentageClient($row['pourcentage_client']);

        }else{

            $clientEnCours->setPourcentageClient(0);

        }


    }

    public function article(ClientTable $clientEnCours)
    {
        $sql = 'SELECT designation
            FROM commande 
            JOIN ligne_commande ON commande.numero = ligne_commande.numero
            JOIN produit  ON ligne_commande.reference = produit.reference
            WHERE codec = ?
            GROUP BY produit.reference, produit.designation
            ORDER BY SUM(ligne_commande.quantite_demandee) DESC
            LIMIT 1';

        $idRequete = $this->executeRequete($sql, [$this->parametres['codec']]);

        if ($idRequete) {
            $row = $idRequete->fetch(PDO::FETCH_ASSOC);

            if ($row && $row["designation"] !== null) {
                $clientEnCours->setArticle($row['designation']);
            } else {
                $clientEnCours->setArticle("--");
            }

        } else {
            // Facultatif : log pour aider au debug
            error_log("La requête SQL dans article() a échoué.");
            $clientEnCours->setArticle(0);
        }
    }


}
