<?php


class AuthentificationControleur {


    private $parametres = []; // Remarque : cette proriété est de type => tableau

    private $oModele; // Remarque : cette proriété est de type => objet
    private $oVue; // Remarque : cette proriété est de type => objet

    /* Constructeur */
    /**
     * @param $parametres // contient les valeurs du tableau $_REQUEST ($_GET et $_POST))
     */
    public function __construct($parametres){
        // Initialisation de la propriété parametres
        $this->parametres = $parametres;

        $this->oModele = new AuthentificationModele($this->parametres);

        $this->oVue = new AuthentificationVue($this->parametres);

    }

    public function form_authentifier(){

        $prepareAuthentification = new authentificationTable($this->parametres);


        $this->oVue->genererAffichageFiche($prepareAuthentification);
}

    public function authentifier(){

        $controleAuthentification = new authentificationTable($this->parametres);

        if($controleAuthentification->getAutorisationSession() == false || $this->oModele->rechercheVendeur($controleAuthentification) == false ) {

            $this->oVue->genererAffichageFiche($controleAuthentification);
        }else{
            header('Location:index.php');
        }
    }

    public function deconnecter()
    {
        session_destroy();
        $_SESSION = [] ;

        header('Location:index.php');
    }

}