<?php

class Autoloader {

    public static function chargerClasse() {

        // Paramètres : le nom de la classe (ici le no en cours Autoloader)
        // et le nom de la méthode qui s'occupe de la recherche des fichiers
        // pour le chargement.

        spl_autoload_register([__CLASS__, 'autoload']);
    }


    private static function autoload($maClasse) {
        // $maClasse accepte les noms type Accueil, AccueilControleur, ...par exemple

        // Mettre en minuscule la première lettre de la classe (celle acceptée en paramètre)
        // pour correspondre au nom du fichier qui lui commence par une minuscule
        $maClasse = lcfirst($maClasse);

        // Créer une variable de type tableau dans lequel on va stocker
        // l'arborescence du projet
        $repertoires = [
            'mod_accueil/',
            'mod_accueil/controleur/',
            'mod_accueil/modele/',
            'mod_accueil/vue/',
            'mod_client/',
            'mod_client/controleur/',
            'mod_client/modele/',
            'mod_client/vue/',
            'mod_authentification/',
            'mod_authentification/controleur/',
            'mod_authentification/modele/',
            'mod_authentification/vue/',
            'mod_produit/',
            'mod_produit/controleur/',
            'mod_produit/modele/',
            'mod_produit/vue/',
            'mod_profil/',
            'mod_profil/controleur/',
            'mod_profil/modele/',
            'mod_profil/vue/',
            'mod_historique/',
            'mod_historique/controleur/',
            'mod_historique/modele/',
            'mod_historique/vue/',
            'mod_commande/',
            'mod_commande/controleur/',
            'mod_commande/modele/',
            'mod_commande/vue/',
        ];

        foreach ($repertoires as $repertoire) {

            //Vérifier si un fichier .php existe dans le répertoire en cours de traitement
            // Si oui, il le charge.
            if(file_exists($repertoire.$maClasse.'.php')) {
                require_once $repertoire.$maClasse.'.php';
                return;
            }

        }

    }

}