<?php

class ProfilVue
{
    private $parametres = []; // Remarque cette propriété est de type => tableau

    private $tpl; //objet Smarty

    //Constructeur

    public function __construct($parametres)
    {

        $this->parametres = $parametres;

        $this->tpl = new Smarty();

    }

    public function chargementValeurs()
    {
        $this->tpl->assign('login', $_SESSION['prenomNom']);

        $this->tpl->assign('titreVue', 'SERAPHIN PARYS');

        if (isset($_SESSION['codevendeur'])) {
            $this->tpl->assign('codevendeur', $_SESSION['codevendeur']);
        }
    }

    public function genererAffichageListe($valeurs)
    {

        $this->chargementValeurs();

        $this->tpl->assign('messageSuccess', ProfilTable::getMessageSucces());
        $this->tpl->assign('titrePage','Liste des profil');

        $this->tpl->assign('listeDesProfils',$valeurs);

        $this->tpl->display('mod_profil/vue/profilListeVue.tpl');


    }
    public function genererAffichageFiche($valeurs){

        $this->chargementValeurs();

        switch ($this->parametres["action"]){
            case "form_consulter":
                $this->tpl->assign('messageErreur', ProfilTable::getMessageErreur());
                $this->tpl->assign('titrePage', 'fiche profil : consultation');
                $this->tpl->assign('readonly', 'disabled');
                $this->tpl->assign('action', 'consulter');

                break;

            case "form_ajouter":
                case "ajouter":

                    $this->tpl->assign('messageErreur', ProfilTable::getMessageErreur());
                $this->tpl->assign('titrePage', 'fiche profil : Création');
                $this->tpl->assign('readonly', '');
                $this->tpl->assign('action', 'ajouter');

                break;

            case "form_modifier":
            case "modifier":

                $this->tpl->assign('messageErreur', ProfilTable::getMessageErreur());
                $this->tpl->assign('titrePage', 'fiche profil : modification');
                $this->tpl->assign('readonly', '');
                $this->tpl->assign('action', 'modifier');

                break;

            case "form_supprimer":
            case "supprimer":

                $this->tpl->assign('messageErreur', ProfilTable::getMessageErreur());
                $this->tpl->assign('titrePage', 'fiche profil : supprimer');
                $this->tpl->assign('readonly', 'disabled');
                $this->tpl->assign('action', 'supprimer');

                break;

            case "form_changerMotDePasse":
                case "changerMotDePasse":

            $this->tpl->assign('messageErreur', ProfilTable::getMessageErreur());
            $this->tpl->assign('titrePage', 'Changer de mot de passe');
            $this->tpl->assign('readonly', '');
            $this->tpl->assign('action', 'changerMotDePasse');
            break;


        }
        $this->tpl->assign('unProfil', $valeurs);
        $this->tpl->assign('messageSucces', ProfilTable::getMessageSucces());
        $this->tpl->assign('messageErreur', ProfilTable::getMessageErreur());
        $this->tpl->display('mod_profil/vue/profilFicheVue.tpl');
    }

}