<?php


class ProfilModele extends Modele{

    private $parametres = []; // Remarque : cette proriété est de type => tableau


    function __construct($parametres){

        $this->parametres = $parametres;

    }


    public function getListeProfils()
    {

        $sql = 'SELECT * FROM vendeur';

        $idRequete = $this->executeRequete($sql);

        // Retour la totalité des clients
        // return $idRequete->fetchall(PDO::FETCH_ASSOC);

        if ($idRequete->rowCount() > 0) {

            while ($profil = $idRequete->fetch(PDO::FETCH_ASSOC)) {


                $listeProfils[] = new ProduitTable($profil);

            }

            return $listeProfils;

        } else {

            return null;
        }
    }
    public function getUnProfil() {
        if (!isset($_SESSION["codevendeur"])) {
            throw new Exception("Aucun vendeur connecté.");
        }

        $sql = 'SELECT * FROM vendeur WHERE codev = ?';
        $idRequete = $this->executeRequete($sql, [$_SESSION["codevendeur"]]);
        return new ProfilTable($idRequete->fetch(PDO::FETCH_ASSOC));
    }
    public function addProfil(ProfilTable $profil)
    {
        $sql = 'INSERT INTO vendeur(nom,prenom,adresse,cp,ville,telephone,login,motdepasse)VALUES(?,?,?,?,?,?,?,?)';

        $idRequete = $this->executeRequete($sql, [

            $profil->getNom(),
            $profil->getPrenom(),
            $profil->getAdresse(),
            $profil->getCp(),
            $profil->getVille(),
            $profil->getTelephone(),
            $profil->getLogin(),
            $profil->getMotdepasse(),
            password_hash($profil->getMotdepasse(), PASSWORD_DEFAULT),
        ]);
        if($idRequete){
            ProfilTable::setMessageSucces("ajout avec succès");
        }
    }

    public function editProfil(ProfilTable $profil)
    {
        $sql = 'UPDATE vendeur SET nom = ?,SET prenom = ? adresse = ?, cp = ?, ville = ?, telephone = ?,login = ?,motdepasse = ? WHERE codec = ?';

        $idRequete = $this->executeRequete($sql, [

            $profil->getNom(),
            $profil->getPrenom(),
            $profil->getAdresse(),
            $profil->getCp(),
            $profil->getVille(),
            $profil->getTelephone(),
            $profil->getLogin(),
            $profil->getMotdepasse(),
        ]);
        if($idRequete){
            ProduitTable::setMessageSucces("modifié avec succes");
        }
    }

    public function supressionPossible()
    {
        $sql = 'SELECT COUNT(*) AS nombre FROM prenom WHERE codev = ?';
        $idRequete = $this->executeRequete($sql, [$this->parametres['codev']]);
        $row = $idRequete->fetch(PDO::FETCH_ASSOC);
        if ($row["nombre"] > 0) {
            return false;
        }else{
            return true;
        }
    }
    public function deleteProfil(){
        $sql = 'DELETE FROM profil WHERE codev = ?';
        $idRequete = $this->executeRequete($sql, [$this->parametres['codev']]);

        if ($idRequete) {

            ProfilTable::setMessageSucces("suppression avec succes");
        }
    }
    public function mettreAJourMotDePasse($motDePasse, $nouveauMotDePasse) {
        if (!isset($_SESSION['codevendeur'])) return false;

        $codev = $_SESSION['codevendeur'];

        $sql = "SELECT motdepasse FROM vendeur WHERE codev = ?";
        $result = $this->executeRequete($sql, [$codev]);

        if ($result && $donnees = $result->fetch(PDO::FETCH_ASSOC)) { //pdo = php data object

           //meme salage et hash que dans setMotdepasse()
            $gauche = "ar30&y%";
            $droite = "tk!@";
            $motDePasseSaisiHashe = hash('ripemd128', "$gauche$motDePasse$droite");

            // Comparer les deux hash
            if ($motDePasseSaisiHashe === $donnees['motdepasse']) {
                // Hash du nouveau mot de passe
                $nouveauMotDePasseHashe = hash('ripemd128', "$gauche$nouveauMotDePasse$droite");

                $sql = "UPDATE vendeur SET motdepasse = ? WHERE codev = ?";
                $this->executeRequete($sql, [$nouveauMotDePasseHashe, $codev]);

                return true;
            }
        }

        return false;
    }

}
