<?php

class ProfilControleur{

    /* Espace déclaration des propriétés */
    private $parametres = []; // Remarque : cette proriété est de type => tableau

    private $oModele; // Remarque : cette proriété est de type => objet
    private $oVue; // Remarque : cette proriété est de type => objet

    /* Constructeur */
    /**
     * @param $parametres // contient les valeurs du tableau $_REQUEST ($_GET et $_POST))
     */
    public function __construct($parametres){
        // Initialisation de la propriété parametres
        $this->parametres = $parametres;

        $this->oModele = new ProfilModele($this->parametres);

        $this->oVue = new ProfilVue($this->parametres);

    }



    public function lister(){

        $lesProfils = $this->oModele->getListeProfils();


        $this->oVue->genererAffichageListe($lesProfils);

    }

    public function form_consulter(){

        $unProfil = $this->oModele->getUnProfil();


        $this->oVue->genererAffichagefiche($unProfil);

    }

    public function form_ajouter(){

        $prepareProfil = new ProfilTable();

        $this->oVue->genererAffichageFiche($prepareProfil);

    }
    public function ajouter(){

    //je controle les données en prevenance du formualaire (sasie utilisateur)
    // si problème alors
    // retourne au formulaire d'ajout avec les données saisies précédément par l'utilisateur
        //message d'erreur
        //sinon ecriture en BDD (nouvelle enregistrement)
        //retourner la vue sur la liste avec un message de succès

        //contrôlle des données
        $controlDonnes = new ProfilTable($this->parametres);

        if($controlDonnes->getAutorisationBD() == false){

            $this->oVue->genererAffichageFiche($controlDonnes);

        }else{

            $this->oModele->addProfil($controlDonnes);
            $this->lister();
        }
    }

    public function form_supprimer(){

        $unProfil = $this->oModele->getUnProduit();

        $this->oVue->genererAffichagefiche($unProfil);

    }
    public function form_modifier(){

        $unProfil = $this->oModele->getUnProfil();

        $this->oVue->genererAffichageFiche($unProfil);

    }

    public function form_changerMotDePasse(){

        $unProfil = $this->oModele->getUnProfil();

        $this->oVue->genererAffichageFiche($unProfil);
    }

    public function modifier(){

        //je controle les données en prevenance du formualaire (sasie utilisateur)
        // si problème alors
        // retourne au formulaire de modification avec les données saisies précédément par l'utilisateur
        //message d'erreur
        //sinon ecriture en BDD (modification enregistrement)
        //retourner la vue sur la liste avec un message de succès

        //contrôlle des données
        $controlDonnes = new ProfilTable($this->parametres);

        if($controlDonnes->getAutorisationBD() == false){

            $this->oVue->genererAffichageFiche($controlDonnes);

        }else{

            $this->oModele->editProfil($controlDonnes);
            $this->lister();
        }
}
        public function supprimer(){
            //je controle l'identifiant du client , est ce qu'il possède une commande ? '
            // si oui alors
            // retourne au formulaire de suppression
            //message d'erreur : client possède au moins une commande
            //sinon ecriture en BDD (nouvelle supression)
            //retourner la vue sur la liste avec un message de succès
            $controleSuppression = $this->oModele->supressionPossible();

            if($controleSuppression == false){
                ProfilTable::setMessageErreur("Impossible de supprimer le profil. Celui ci possède au moins une commande.");
                $this->oVue->genererAffichageFiche($this->oModele->getUnProfil());
            }else{
                $this->oModele->deleteProfil();

                $this->lister();
            }
        }

    public function changerMotDePasse() {
        $motDePasse = $this->parametres['motDePasse'] ?? '';
        $nouveauMotDePasse = $this->parametres['nouveauMotDePasse'] ?? '';
        $confirmNouveauMotDePasse = $this->parametres['confirmNouveauMotDePasse'] ?? '';

        if ($nouveauMotDePasse !== $confirmNouveauMotDePasse) {
            ProfilTable::setMessageErreur("❌ Les mots de passe ne correspondent pas.");
        } elseif (empty($motDePasse) || empty($nouveauMotDePasse)) {
            ProfilTable::setMessageErreur("⚠️ Tous les champs sont obligatoires.");
        } else {
            $succes = $this->oModele->mettreAJourMotDePasse($motDePasse, $nouveauMotDePasse);
            if ($succes) {
                ProfilTable::setMessageSucces("✅ Mot de passe mis à jour avec succès.");
            } else {
                ProfilTable::setMessageErreur("❌ Ancien mot de passe incorrect.");
            }
        }

        // Recharge la fiche profil avec le message
        $unProfil = $this->oModele->getUnProfil();
        $this->oVue->genererAffichageFiche($unProfil);
    }


}