<?php

class HistoriqueVue
{
    private $parametres = []; // Remarque cette propriété est de type => tableau

    private $tpl; //objet Smarty

    //Constructeur

    public function __construct($parametres)
    {

        $this->parametres = $parametres;

        $this->tpl = new Smarty();

    }

    public function chargementValeurs()
    {
        $this->tpl->assign('login', $_SESSION['prenomNom']);

        $this->tpl->assign('titreVue', 'SERAPHIN PARYS');

    }

    public function genererAffichageListe($valeurs)
    {

        $this->chargementValeurs();

        $this->tpl->assign('messageSuccess', HistoriqueTable::getMessageSucces());
        $this->tpl->assign('titrePage','Liste des Historiques');

        $this->tpl->assign('listeDesHistoriques',$valeurs);

        $this->tpl->display('mod_historique/vue/historiqueListeVue.tpl');


    }
    public function genererAffichageFiche($valeurs){

        $this->chargementValeurs();

        switch ($this->parametres["action"]){
            case "form_consulter":
                $this->tpl->assign('messageErreur', HistoriqueTable::getMessageErreur());
                $this->tpl->assign('titrePage', 'fiche historique : consultation');
                $this->tpl->assign('readonly', 'disabled');
                $this->tpl->assign('action', 'consulter');

                break;

            case "form_ajouter":
                case "ajouter":

                    $this->tpl->assign('messageErreur', ClientTable::getMessageErreur());
                $this->tpl->assign('titrePage', 'fiche client : Création');
                $this->tpl->assign('readonly', '');
                $this->tpl->assign('action', 'ajouter');

                break;

            case "form_modifier":
            case "modifier":

                $this->tpl->assign('messageErreur', ClientTable::getMessageErreur());
                $this->tpl->assign('titrePage', 'fiche client : modification');
                $this->tpl->assign('readonly', '');
                $this->tpl->assign('action', 'modifier');

                break;

            case "form_supprimer":
            case "supprimer":

                $this->tpl->assign('messageErreur', ClientTable::getMessageErreur());
                $this->tpl->assign('titrePage', 'fiche client : supprimer');
                $this->tpl->assign('readonly', 'disabled');
                $this->tpl->assign('action', 'supprimer');

                break;


        }
        $this->tpl->assign('unClient', $valeurs);

        $this->tpl->display('mod_client/vue/clientFicheVue.tpl');
    }

}