<?php

class ProduitVue
{
    private $parametres = []; // Remarque cette propriété est de type => tableau

    private $tpl; //objet Smarty

    //Constructeur

    public function __construct($parametres)
    {

        $this->parametres = $parametres;

        $this->tpl = new Smarty();

    }

    public function chargementValeurs()
    {
        $this->tpl->assign('login', 'Ici le nom de la personne authentiée');

        $this->tpl->assign('titreVue', 'SERAPHIN PARYS');
    }

    public function genererAffichageListe($valeurs)
    {

        $this->chargementValeurs();

        $this->tpl->assign('messageSuccess', ProduitTable::getMessageSucces());
        $this->tpl->assign('titrePage','Liste des Produits');

        $this->tpl->assign('listeDesProduits',$valeurs);

        $this->tpl->display('mod_produit/vue/produitListeVue.tpl');


    }
    public function genererAffichagefiche($valeurs){

        $this->chargementValeurs();

        switch ($this->parametres["action"]){
            case "form_consulter":
                $this->tpl->assign('messageErreur', ProduitTable::getMessageErreur());
                $this->tpl->assign('titrePage', 'fiche client : consultation');
                $this->tpl->assign('readonly', 'disabled');
                $this->tpl->assign('action', 'consulter');

                break;

            case "form_ajouter":
                case "ajouter":

                    $this->tpl->assign('messageErreur', ProduitTable::getMessageErreur());
                $this->tpl->assign('titrePage', 'fiche client : Création');
                $this->tpl->assign('readonly', '');
                $this->tpl->assign('action', 'ajouter');

                break;

            case "form_modifier":
            case "modifier":

                $this->tpl->assign('messageErreur', ProduitTable::getMessageErreur());
                $this->tpl->assign('titrePage', 'fiche client : modification');
                $this->tpl->assign('readonly', '');
                $this->tpl->assign('action', 'modifier');

                break;

            case "form_supprimer":
            case "supprimer":

                $this->tpl->assign('messageErreur', ProduitTable::getMessageErreur());
                $this->tpl->assign('titrePage', 'fiche client : supprimer');
                $this->tpl->assign('readonly', 'disabled');
                $this->tpl->assign('action', 'supprimer');

                break;


        }
        $this->tpl->assign('unClient', $valeurs);

        $this->tpl->display('mod_client/vue/produitFicheVue.tpl');
    }

}