<?php


class ProduitModele extends Modele{

    private $parametres = []; // Remarque : cette proriété est de type => tableau


    function __construct($parametres){

        $this->parametres = $parametres;

    }


    public function getListeProduits()
    {

        $sql = 'SELECT * FROM produit';

        $idRequete = $this->executeRequete($sql);

        // Retour la totalité des clients
        // return $idRequete->fetchall(PDO::FETCH_ASSOC);

        if ($idRequete->rowCount() > 0) {

            while ($produit = $idRequete->fetch(PDO::FETCH_ASSOC)) {


                $listeProduits[] = new ProduitTable($produit);

            }

            return $listeProduits;

        } else {

            return null;
        }
    }
    public function getUnProduit(){

            $sql = 'SELECT * FROM produit WHERE reference = ?';

            $idRequete = $this->executeRequete($sql, [$this->parametres["reference"]]);

            $unProduit = new ProduitTable($idRequete->fetch(PDO::FETCH_ASSOC));

            return $unProduit;
    }
    public function addProduit(ProduitTable $produit)
    {
        $sql = 'INSERT INTO produit(reference,descriptif,designation,poids_pièce,prix_unitaire_HT)VALUES(?,?,?,?,?)';

        $idRequete = $this->executeRequete($sql, [

            $produit->getReference(),
            $produit->getDescriptif(),
            $produit->getDesignation(),
            $produit->getPoidsPiece(),
            $produit->getPrixUnitaireHT(),
        ]);
        if($idRequete){
            ProduitTable::setMessageSucces("ajout avec succès");
        }
    }

    public function editClient(ClientTable $client)
    {
        $sql = 'UPDATE client SET nom = ?, adresse = ?, cp = ?, ville = ?, telephone = ? WHERE codec = ?';

        $idRequete = $this->executeRequete($sql, [

            $client->getNom(),
            $client->getAdresse(),
            $client->getCp(),
            $client->getVille(),
            $client->getTelephone(),
            $client->getCodec(),
        ]);
        if($idRequete){
            ClientTable::setMessageSucces("modifié avec succes");
        }
    }

    public function supressionPossible()
    {
        $sql = 'SELECT COUNT(*) AS nombre FROM commande WHERE reference = ?';
        $idRequete = $this->executeRequete($sql, [$this->parametres['reference']]);
        $row = $idRequete->fetch(PDO::FETCH_ASSOC);
        if ($row["nombre"] > 0) {
            return false;
        }else{
            return true;
        }
    }
    public function deleteClient(){
        $sql = 'DELETE FROM client WHERE reference = ?';
        $idRequete = $this->executeRequete($sql, [$this->parametres['reference']]);

        if ($idRequete) {

            ProduitTable::setMessageSucces("suppression avec succes");
        }
    }
}
