<?php

class ProduitTable
{
    private $reference = "";
    private $descriptif = "";
    private $designation = "";
    private $poidsPiece = "";
    private $prix_unitaire_HT = "";
    private $autorisationBD = "";
    private $quantite = 0;




    protected static $messageSucces = "";
    protected static $messageErreur = "";

    public function __construct($data = null)
    {
        if ($data != null) {
            $this->hydrater($data);
        }
    }

    public function hydrater(array $data)
    {
        foreach ($data as $key => $value) {
            $setter = 'set' . ucfirst($key);
            if (method_exists($this, $setter)) {
                $this->$setter($value);
            }
        }
    }

    public function getReference(): string
    {
        return $this->reference;
    }

    public function getDescriptif(): string
    {
        return $this->descriptif;
    }

    public function getDesignation(): string
    {
        return $this->designation;
    }

    public function getPoidsPiece(): string
    {
        return $this->poidsPiece;
    }

    public function getPrixUnitaireHT(): string
    {
        return $this->prix_unitaire_HT;
    }

    public function setReference(string $reference): void
    {
        $this->reference = $reference;
    }

    public function setDescriptif(string $descriptif): void
    {
        $this->descriptif = $descriptif;
    }

    public function setDesignation(string $designation): void
    {
        $this->designation = $designation;
    }

    public function setPoidsPiece(string $poidsPiece): void
    {
        $this->poidsPiece = $poidsPiece;
    }

    public function setPrixUnitaireHT(string $prix_unitaire_HT): void
    {
        $this->prix_unitaire_HT = $prix_unitaire_HT;
    }

    public function setAutorisationBD(string $autorisationBD): void
    {
        $this->autorisationBD = $autorisationBD;
    }

    public function getAutorisationBD(): string
    {
        return $this->autorisationBD;
    }

    public static function getMessageErreur(): string
    {
        return self::$messageErreur;
    }

    public static function getMessageSucces(): string
    {
        return self::$messageSucces;
    }

    public static function setMessageErreur(string $messageErreur): void
    {
        self::$messageErreur .= $messageErreur;
    }

    public static function setMessageSucces(string $messageSucces): void
    {
        self::$messageSucces = $messageSucces;
    }

    public function getQuantite(): int
    {
        return $this->quantite;
    }

    public function setQuantite(int $quantite): void
    {
        $this->quantite = $quantite;
    }


}
