<?php


class AuthentificationTable {

    //déclaration des propriétés

    private $login = "";

    private $motdepasse = "";

    private $autorisationSession = true;

    private static $messageErreur = "";



    public function __construct($data = null)
    {

        if ($data != null) {

            $this->hydrater($data);
        }


    }
    public function hydrater(array $data)
    {
        foreach ($data as $key => $value) {
            //Concaténation du nom de la clé avec le préfixe set (construction pour l'appel du setter)
            $setter = 'set' . ucfirst($key);
            // appeler une fonction qui me permet de vérifier si la méthode de type setter existe.
            if (method_exists($this, $setter)) {
                // invoquer la méthode correspondante
                $this->$setter($value);
            }
        }
    }

    public function getLogin(): string
    {
        return $this->login;
    }

    public function getMotdepasse(): string
    {
        return $this->motdepasse;
    }

    public function getAutorisationSession(): bool
    {
        return $this->autorisationSession;
    }

    public static function getMessageErreur(): string
    {
        return self::$messageErreur;
    }

    public static function setMessageErreur(string $messageErreur): void
    {
        self::$messageErreur = $messageErreur . self::$messageErreur;
    }

    public function setAutorisationSession(bool $autorisationSession): void
    {
        $this->autorisationSession = $autorisationSession;
    }

    public function setMotdepasse(string $motdepasse): void
    {
        if(!empty($motdepasse) && !ctype_space($motdepasse)){
         //mdp potentiellment ok
         //utilisation de la technique de SALAGE
            //mot de passe utiliser pour l'application : sowhat
            //le mot de passe doit devenir (concatènation):   ar30&y%sowhattk!@

            $gauche = "ar30&y%";
            $droite = "tk!@";
            $this->motdepasse = hash('ripemd128', "$gauche$motdepasse$droite");


        }else{
            self::setMessageErreur("Vous devez saisir un mot de passe <br>");
            $this->setAutorisationSession(false);
            $this->motdepasse = "";
        }


    }

    public function setLogin(string $login): void
    {
        if(empty($login)|| ctype_space($login)){

            self::setMessageErreur("Veuillez saisir votre mot de passe <br>");
            $this->setAutorisationSession(false) ;
        }
        $this->login = $login;
    }


}
