<?php

class ProduitTable
{
    private $reference = "";
    private $descriptif = "";
    private $designation = "";
    private $poids_piece = "";
    private $prix_unitaire_HT = "";



    public function __construct($data = null)
    {

        if ($data != null) {

            $this->hydrater($data);
        }


    }

    public function hydrater(array $data)
    {
        foreach ($data as $key => $value) {
            //Concaténation du nom de la clé avec le préfixe set (construction pour l'appel du setter)
            $setter = 'set' . ucfirst($key);
            // appeler une fonction qui me permet de vérifier si la méthode de type setter existe.
            if (method_exists($this, $setter)) {
                // invoquer la méthode correspondante
                $this->$setter($value);
            }
        }
    }

    public function getReference(): string
    {
        return $this->reference;
    }

    public function getDescriptif(): string
    {
        return $this->descriptif;
    }

    public function getDesignation(): string
    {
        return $this->designation;
    }

    public function getPoidsPiece(): string
    {
        return $this->poids_pièce;
    }

    public function getPrixUnitaireHT(): string
    {
        return $this->prix_unitaire_HT;
    }

    public function setReference(string $reference): void
    {
        $this->reference = $reference;
    }

    public function setDescriptif(string $descriptif): void
    {
        $this->descriptif = $descriptif;
    }

    public function setDesignation(string $designation): void
    {
        $this->designation = $designation;
    }

    public function setPoidsPièce(string $poids_pièce): void
    {
        $this->poids_pièce = $poids_pièce;
    }

    public function setPrixUnitaireHT(string $prix_unitaire_HT): void
    {
        $this->prix_unitaire_HT = $prix_unitaire_HT;
    }

    public function setTelephone(string $telephone): void
    {
        $this->telephone = $telephone;
    }

    public function getAutorisationBD(): string
    {
        return $this->autorisationBD;
    }

    public static function getMessageErreur(): string
    {
        return self::$messageErreur;
    }

    public static function getMessageSucces(): string
    {
        return self::$messageSucces;
    }

    public function setAutorisationBD(string $autorisationBD): void
    {
        $this->autorisationBD = $autorisationBD;
    }

    public static function setMessageErreur(string $messageErreur): void
    {
        self::$messageErreur = self::$messageErreur . $messageErreur;    }

    public static function setMessageSucces(string $messageSucces): void
    {
        self::$messageSucces = $messageSucces;
    }







}