<?php


class ClientModele extends Modele{

    private $parametres = []; // Remarque : cette proriété est de type => tableau


    function __construct($parametres){

        $this->parametres = $parametres;

    }


    public function getListeClients()
    {

        $sql = 'SELECT * FROM client';

        $idRequete = $this->executeRequete($sql);

        // Retour la totalité des clients
        // return $idRequete->fetchall(PDO::FETCH_ASSOC);

        if ($idRequete->rowCount() > 0) {

            while ($client = $idRequete->fetch(PDO::FETCH_ASSOC)) {


                $listeClients[] = new ClientTable($client);

            }

            return $listeClients;

        } else {

            return null;
        }
    }
    public function getUnClient(){

            $sql = 'SELECT * FROM client WHERE codec = ?';

            $idRequete = $this->executeRequete($sql, [$this->parametres["codec"]]);

            $unClient = new ClientTable($idRequete->fetch(PDO::FETCH_ASSOC));

            return $unClient;
    }
    public function addClient(ClientTable $client)
    {
        $sql = 'INSERT INTO client(nom,adresse,cp,ville,telephone)VALUES(?,?,?,?,?)';

        $idRequete = $this->executeRequete($sql, [

            $client->getNom(),
            $client->getAdresse(),
            $client->getCp(),
            $client->getVille(),
            $client->getTelephone(),
        ]);
        if($idRequete){
            ClientTable::setMessageSucces("ajout avec succès");
        }
    }

    public function editClient(ClientTable $client)
    {
        $sql = 'UPDATE client SET nom = ?, adresse = ?, cp = ?, ville = ?, telephone = ? WHERE codec = ?';

        $idRequete = $this->executeRequete($sql, [

            $client->getNom(),
            $client->getAdresse(),
            $client->getCp(),
            $client->getVille(),
            $client->getTelephone(),
            $client->getCodec(),
        ]);
        if($idRequete){
            ClientTable::setMessageSucces("modifié avec succes");
        }
    }

    public function supressionPossible()
    {
        $sql = 'SELECT COUNT(*) AS nombre FROM commande WHERE codec = ?';
        $idRequete = $this->executeRequete($sql, [$this->parametres['codec']]);
        $row = $idRequete->fetch(PDO::FETCH_ASSOC);
        if ($row["nombre"] > 0) {
            return false;
        }else{
            return true;
        }
    }
    public function deleteClient(){
        $sql = 'DELETE FROM client WHERE codec = ?';
        $idRequete = $this->executeRequete($sql, [$this->parametres['codec']]);

        if ($idRequete) {

            ClientTable::setMessageSucces("suppression avec succes");
        }
    }
}
