<?php

class ClientVue
{
    private $parametres = []; // Remarque cette propriété est de type => tableau

    private $tpl; //objet Smarty

    //Constructeur

    public function __construct($parametres)
    {

        $this->parametres = $parametres;

        $this->tpl = new Smarty();

    }

    public function chargementValeurs()
    {
        $this->tpl->assign('login', 'Ici le nom de la personne authentiée');

        $this->tpl->assign('titreVue', 'SERAPHIN PARYS');
    }

    public function genererAffichageListe($valeurs)
    {

        $this->chargementValeurs();

        $this->tpl->assign('messageSuccess', ClientTable::getMessageSucces());
        $this->tpl->assign('titrePage','Liste des clients');

        $this->tpl->assign('listeDesClients',$valeurs);

        $this->tpl->display('mod_client/vue/clientListeVue.tpl');


    }
    public function genererAffichageFiche($valeurs){

        $this->chargementValeurs();

        switch ($this->parametres["action"]){
            case "form_consulter":

                $this->tpl->assign('titrePage', 'fiche client : consultation');
                $this->tpl->assign('readonly', 'disabled');
                $this->tpl->assign('action', 'consulter');

                break;

            case "form_ajouter":
                case "ajouter":

                    $this->tpl->assign('messageErreur', ClientTable::getMessageErreur());
                $this->tpl->assign('titrePage', 'fiche client : Création');
                $this->tpl->assign('readonly', '');
                $this->tpl->assign('action', 'ajouter');

                break;

        }
        $this->tpl->assign('unClient', $valeurs);

        $this->tpl->display('mod_client/vue/clientFicheVue.tpl');
    }

}