<?php

class ClientTable {

    private $codec = "";
    private $nom  = "";
    private $adresse  = "";
    private $cp  = "";
    private $ville  = "";
    private $telephone  = "";


    public function __construct($data = null)
    {
        if ($data != null) {

            $this->hydrater($data);
        }

    }

    public function hydrater(array $data)
    {
        foreach ($data as $key => $value) {
            //Concaténation du nom de la clé avec le préfixe set (construction pour l'appel du setter)
            $setter = 'set' . ucfirst($key);
            // appeler une fonction qui me permet de vérifier si la méthode de type setter existe.
            if (method_exists($this, $setter)) {
                // invoquer la méthode correspondante
                $this->$setter($value);
            }
        }
    }

    /**
     * @return string
     */
    public function getCodec()
    {
        return $this->codec;
    }

    /**
     * @param string $codec
     */
    public function setCodec($codec)
    {
        $this->codec = $codec;
    }

    /**
     * @return string
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * @param string $nom
     */
    public function setNom($nom)
    {
        $this->nom = $nom;
    }

    /**
     * @return string
     */
    public function getAdresse()
    {
        return $this->adresse;
    }

    /**
     * @param string $adresse
     */
    public function setAdresse($adresse)
    {
        $this->adresse = $adresse;
    }

    /**
     * @return string
     */
    public function getCp()
    {
        return $this->cp;
    }

    /**
     * @param string $cp
     */
    public function setCp($cp)
    {
        $this->cp = $cp;
    }


    /**
     * @return string
     */
    public function getVille()
    {
        return $this->ville;
    }

    /**
     * @param string $ville
     */
    public function setVille($ville)
    {
        $this->ville = $ville;
    }

    /**
     * @return string
     */
    public function getTelephone()
    {
        return $this->telephone;
    }

    /**
     * @param string $telephone
     */
    public function setTelephone($telephone)
    {
        $this->telephone = $telephone;
    }




}