<?php

class Autoloader {


    public static function chargerClasse() {

        // Paramètres : le nom de la Classe (ici le nom en cours Autoloader )
        //et le nom de la méthode qui s'occupe de la recherche pour le chargement

        spl_autoload_register([__CLASS__, 'autoload']);

    }

    private static function autoload($maClasse)
    {
        //$maClass accepte les nom de type Accueil, AccueilControlleur par exemple

        //mettre en minuscule La première lettre de la classe (celle accptée en paramètre
        //pour correspondre au nom du fichier qui lui commence par une minuscule

        $maClasse = lcfirst($maClasse);

        //Créer une variable de type tableau dans lequel on va stocker
        //l'arborescence du projet
        $repertoires = [

            'mod_accueil/',
            'mod_accueil/controleur/',
            'mod_accueil/modele/',
            'mod_accueil/vue/',


        ];

        foreach ($repertoires as $repertoire) {

            //vérifier si un fichier .php existe dans les répertoires
            //Si oui, il le charge.
            if (file_exists($repertoire . $maClasse . '.php')) {
                require_once $repertoire.$maClasse . '.php';
                return ;
            }
        }
    }
}