<?php
try {
    if (isset($_GET['wDemande']) && $_GET['wDemande'] === 'aNot24get') {
        define('SERVEUR', 'localhost');
        define('NOM', 'root');
        define('PASSE', '');
        define('BASE', 'seraphinparys');

        $cnx = new PDO('mysql:host='.SERVEUR.';dbname='.BASE, NOM, PASSE, [
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4",
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        ]);

        $ref = isset($_POST['reference']) ? trim($_POST['reference']) : '';
        $qty = isset($_POST['stock']) ? (int)$_POST['stock'] : 0;

        if ($ref === '' || $qty <= 0) {
            echo "Erreur";
            exit;
        }

        // Récupère le stock actuel
        $stmt = $cnx->prepare("SELECT stock FROM produit WHERE reference = ?");
        $stmt->execute([$ref]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$row) {
            echo "Produit introuvable";
            exit;
        }

        $newStock = (int)$row['stock'] + $qty;

        // Mise à jour
        $upd = $cnx->prepare("UPDATE produit SET stock = ? WHERE reference = ?");
        $upd->execute([$newStock, $ref]);

        echo "OK ; ".$newStock;
    } else {
        echo "Accès interdit";
    }
} catch (PDOException $e) {
    echo "Erreur DB : ".$e->getMessage();
    exit;
}
